# ---- Salicornia biomass calibration (planform area [cm2] ---> dry mass [g]) ----- #
library(scales)



setwd('/Users/gfivash/Dropbox/Greg/Work/PhD/Thesis Chapters/Chapter 3 - Sediment hummocks/Data Chapter 3 submission/Figure S3 - mass-area calibration/')
d = read.csv("Salicornia area - biomass calibration.csv")

# Biomass has ben measured at the level of the entire inidividual and is stored
# in the first row of each individual (which introduces many NAs)
biomass.g = d$dry_biomass.g[is.na(d$dry_biomass.g) == F]
biomass.mg = biomass.g*1000
# Area has been quantified at the level of individual branches and must be summed 
# to quantify the total measured area on an individual
area.cm2 = as.numeric(tapply(d$area.cm2, d$individual.ID, sum))[1:length(biomass.g)]

# Below a threshold size, the balance can no longer propperly detect mass differences
# These extrememly small individuals have been removed from the calibration
filter = area.cm2 > 0.255

plotDirectory = '/Users/gfivash/Desktop/'
setwd(plotDirectory)
tiff("Figure S3.tif",
     width = 7, height = 6, 
     units = 'in', res = 300)

plot(biomass.mg[filter] ~ area.cm2[filter], log ='yx', 
     pch = 21, bg = alpha('green',0.5), cex = 0.9,
     ylab = 'Biomass (mg)', xlab = ~ "Area " (cm^2))

m = lm(log(biomass.mg[filter]) ~ log(area.cm2[filter]))
a = exp(summary(m)$coefficients[1])
b = summary(m)$coefficients[2]
xv = seq(0.255,max(area.cm2), length.out = 100)
yv = a*xv^b
lines(yv ~ xv, lwd = 2)
#text(x = 2.5, y = 2, paste('Biomass [g] =', round(a, digits = 3), '* Area [cm2] ^',round(b, digits = 3)), cex = 0.9)
text(x = 2.5, y = 2, expression('Biomass (mg) = 10.02 * Area (cm'^2*')'^1.159), cex = 0.9)
text(x = 1.25, y = 113, expression('(R'^2 * ' = 0.963, n = 126, p < 0.0001)'), cex = 0.9)
summary(m)

dev.off()
